<?php
/* --------------------------------------------------------------
 RoutingMiddlewareRegistration.php 2020-03-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel\Bootstrapper;

use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Slim\App as SlimApp;

/**
 * Class RoutingMiddlewareRegistration
 * @package Gambio\Core\Application\Kernel\Bootstrapper
 */
class RoutingMiddlewareRegistration extends AbstractBootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        /** @var SlimApp $slim */
        $slim = $application->get(SlimApp::class);
        $slim->addRoutingMiddleware();
    }
}